/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.tylermurphy.hideAndSeek.configuration.ConfigManager;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class Items {
    public static List<ItemStack> HIDER_ITEMS;
    public static List<ItemStack> SEEKER_ITEMS;
    public static List<PotionEffect> HIDER_EFFECTS;
    public static List<PotionEffect> SEEKER_EFFECTS;

    public static void loadItems() {
        ConfigurationSection section;
        ConfigurationSection section2;
        ConfigurationSection section3;
        ConfigurationSection section4;
        ConfigManager manager = new ConfigManager("items.yml");
        SEEKER_ITEMS = new ArrayList<ItemStack>();
        ConfigurationSection SeekerItems = manager.getConfigurationSection("items.seeker");
        int i = 1;
        while ((section4 = SeekerItems.getConfigurationSection(String.valueOf(i))) != null) {
            ItemStack item = Items.createItem(section4);
            if (item != null) {
                SEEKER_ITEMS.add(item);
            }
            ++i;
        }
        HIDER_ITEMS = new ArrayList<ItemStack>();
        ConfigurationSection HiderItems = manager.getConfigurationSection("items.hider");
        i = 1;
        while ((section3 = HiderItems.getConfigurationSection(String.valueOf(i))) != null) {
            ItemStack item = Items.createItem(section3);
            if (item != null) {
                HIDER_ITEMS.add(item);
            }
            ++i;
        }
        SEEKER_EFFECTS = new ArrayList<PotionEffect>();
        ConfigurationSection SeekerEffects = manager.getConfigurationSection("effects.seeker");
        i = 1;
        while ((section2 = SeekerEffects.getConfigurationSection(String.valueOf(i))) != null) {
            PotionEffect effect = Items.getPotionEffect(section2);
            if (effect != null) {
                SEEKER_EFFECTS.add(effect);
            }
            ++i;
        }
        HIDER_EFFECTS = new ArrayList<PotionEffect>();
        ConfigurationSection HiderEffects = manager.getConfigurationSection("effects.hider");
        i = 1;
        while ((section = HiderEffects.getConfigurationSection(String.valueOf(i))) != null) {
            PotionEffect effect = Items.getPotionEffect(section);
            if (effect != null) {
                HIDER_EFFECTS.add(effect);
            }
            ++i;
        }
    }

    private static ItemStack createItem(ConfigurationSection item) {
        String material_string = item.getString("material");
        if (material_string == null) {
            return null;
        }
        Material material = Material.valueOf((String)material_string.toUpperCase());
        int amount = item.getInt("amount");
        ItemStack stack = new ItemStack(material, amount);
        if (material == Material.POTION || material == Material.SPLASH_POTION || material == Material.LINGERING_POTION) {
            PotionMeta meta = Items.getPotionMeta(stack, item);
            stack.setItemMeta((ItemMeta)meta);
        } else {
            ConfigurationSection enchantments = item.getConfigurationSection("enchantments");
            if (enchantments != null) {
                for (String enchantment_string : enchantments.getKeys(false)) {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantment_string));
                    if (enchantment == null) continue;
                    stack.addUnsafeEnchantment(enchantment, enchantments.getInt(enchantment_string));
                }
            }
            ItemMeta meta = Items.getItemMeta(stack, item);
            stack.setItemMeta(meta);
        }
        return stack;
    }

    private static ItemMeta getItemMeta(ItemStack stack, ConfigurationSection item) {
        ItemMeta meta = stack.getItemMeta();
        assert (meta != null);
        String name = item.getString("name");
        if (name != null) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        meta.setUnbreakable(item.getBoolean("unbreakable"));
        meta.setLore(item.getStringList("lore"));
        return meta;
    }

    private static PotionMeta getPotionMeta(ItemStack stack, ConfigurationSection item) {
        String type = item.getString("type");
        PotionMeta meta = (PotionMeta)stack.getItemMeta();
        if (type == null) {
            return meta;
        }
        assert (meta != null);
        meta.setBasePotionData(new PotionData(PotionType.valueOf((String)type.toUpperCase())));
        return meta;
    }

    private static PotionEffect getPotionEffect(ConfigurationSection item) {
        String type = item.getString("type");
        if (type == null) {
            return null;
        }
        return new PotionEffect(Objects.requireNonNull(PotionEffectType.getByName((String)type.toUpperCase())), item.getInt("duration"), item.getInt("amplifier"), item.getBoolean("ambient"), item.getBoolean("particles"));
    }
}

