/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import net.tylermurphy.hideAndSeek.configuration.ConfigManager;
import org.bukkit.util.Vector;

public class Config {
    private static ConfigManager manager;
    public static String messagePrefix;
    public static String errorPrefix;
    public static String tauntPrefix;
    public static String worldborderPrefix;
    public static String abortPrefix;
    public static String gameoverPrefix;
    public static String warningPrefix;
    public static String spawnWorld;
    public static String exitWorld;
    public static String lobbyWorld;
    public static String local;
    public static Vector spawnPosition;
    public static Vector lobbyPosition;
    public static Vector exitPosition;
    public static Vector worldborderPosition;
    public static boolean nametagsVisible;
    public static boolean permissionsRequired;
    public static boolean announceMessagesToNonPlayers;
    public static boolean worldborderEnabled;
    public static boolean tauntEnabled;
    public static boolean tauntCountdown;
    public static boolean tauntLast;
    public static boolean glowEnabled;
    public static boolean glowStackable;
    public static boolean pvpEnabled;
    public static boolean autoJoin;
    public static boolean teleportToExit;
    public static int minPlayers;
    public static int worldborderSize;
    public static int worldborderDelay;
    public static int currentWorldborderSize;
    public static int gameLength;
    public static int saveMinX;
    public static int saveMinZ;
    public static int saveMaxX;
    public static int saveMaxZ;
    public static int tauntDelay;
    public static int glowLength;

    public static void loadConfig() {
        manager = new ConfigManager("config.yml");
        manager.saveConfig();
        spawnPosition = new Vector(manager.getDouble("spawns.game.x"), Math.max(0.0, Math.min(255.0, manager.getDouble("spawns.game.y"))), manager.getDouble("spawns.game.z"));
        spawnWorld = manager.getString("spawns.game.world");
        lobbyPosition = new Vector(manager.getDouble("spawns.lobby.x"), Math.max(0.0, Math.min(255.0, manager.getDouble("spawns.lobby.y"))), manager.getDouble("spawns.lobby.z"));
        lobbyWorld = manager.getString("spawns.lobby.world");
        announceMessagesToNonPlayers = manager.getBoolean("announceMessagesToNonPlayers");
        exitPosition = new Vector(manager.getDouble("spawns.exit.x"), Math.max(0.0, Math.min(255.0, manager.getDouble("spawns.exit.y"))), manager.getDouble("spawns.exit.z"));
        exitWorld = manager.getString("spawns.exit.world");
        worldborderPosition = new Vector(manager.getInt("worldBorder.x"), 0, manager.getInt("worldBorder.z"));
        worldborderSize = Math.max(100, manager.getInt("worldBorder.size"));
        worldborderDelay = Math.max(1, manager.getInt("worldBorder.delay"));
        worldborderEnabled = manager.getBoolean("worldBorder.enabled");
        char SYMBOLE = '\u00a7';
        String SYMBOLE_STRING = String.valueOf(SYMBOLE);
        messagePrefix = manager.getString("prefix.default").replace("&", SYMBOLE_STRING);
        errorPrefix = manager.getString("prefix.error").replace("&", SYMBOLE_STRING);
        tauntPrefix = manager.getString("prefix.taunt").replace("&", SYMBOLE_STRING);
        worldborderPrefix = manager.getString("prefix.border").replace("&", SYMBOLE_STRING);
        abortPrefix = manager.getString("prefix.abort").replace("&", SYMBOLE_STRING);
        gameoverPrefix = manager.getString("prefix.gameover").replace("&", SYMBOLE_STRING);
        warningPrefix = manager.getString("prefix.warning").replace("&", SYMBOLE_STRING);
        saveMinX = manager.getInt("bounds.min.x");
        saveMinZ = manager.getInt("bounds.min.z");
        saveMaxX = manager.getInt("bounds.max.x");
        saveMaxZ = manager.getInt("bounds.max.z");
        tauntEnabled = manager.getBoolean("taunt.enabled");
        tauntCountdown = manager.getBoolean("taunt.showCountdown");
        tauntDelay = Math.max(60, manager.getInt("taunt.delay"));
        tauntLast = manager.getBoolean("taunt.whenLastPerson");
        glowLength = Math.max(1, manager.getInt("glow.time"));
        glowStackable = manager.getBoolean("glow.stackable");
        glowEnabled = manager.getBoolean("glow.enabled");
        nametagsVisible = manager.getBoolean("nametagsVisible");
        permissionsRequired = manager.getBoolean("permissionsRequired");
        minPlayers = Math.max(2, manager.getInt("minPlayers"));
        gameLength = manager.getInt("gameLength");
        pvpEnabled = manager.getBoolean("pvp");
        autoJoin = manager.getBoolean("autoJoin");
        teleportToExit = manager.getBoolean("teleportToExit");
        local = manager.getString("local");
    }

    public static void addToConfig(String path, Object value) {
        manager.set(path, value);
    }

    public static void saveConfig() {
        manager.saveConfig();
    }
}

