/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.events.Worldborder;
import net.tylermurphy.hideAndSeek.util.Packet;
import net.tylermurphy.hideAndSeek.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Stop
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!Util.isSetup()) {
            sender.sendMessage(Config.errorPrefix + "Game is not setup. Run /hs setup to see what you needed to do");
            return;
        }
        if (Main.plugin.status.equals("Starting") || Main.plugin.status.equals("Playing")) {
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.abortPrefix + Localization.message("STOP")));
            } else {
                Util.broadcastMessage(Config.abortPrefix + Localization.message("STOP"));
            }
        } else {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_NOT_INPROGRESS"));
            return;
        }
        Stop.onStop();
    }

    @Override
    public String getLabel() {
        return "stop";
    }

    public static void onStop() {
        if (Main.plugin.status.equals("Standby")) {
            return;
        }
        Main.plugin.status = "Standby";
        ++Main.plugin.gameId;
        Main.plugin.timeLeft = 0;
        Worldborder.resetWorldborder("hideandseek_" + Config.spawnWorld);
        for (Player player : Main.plugin.board.getPlayers()) {
            Main.plugin.board.createLobbyBoard(player);
            player.setGameMode(GameMode.ADVENTURE);
            Main.plugin.board.addHider(player);
            player.getInventory().clear();
            player.teleport(new Location(Bukkit.getWorld((String)Config.lobbyWorld), Config.lobbyPosition.getX(), Config.lobbyPosition.getY(), Config.lobbyPosition.getZ()));
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 1, 100));
            for (Player temp : Main.plugin.board.getPlayers()) {
                Packet.setGlow(player, temp, false);
            }
        }
        Main.plugin.worldLoader.unloadMap();
        Main.plugin.board.reloadLobbyBoards();
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Stops the game";
    }
}

