/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import java.util.Random;
import net.md_5.bungee.api.ChatColor;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.events.Glow;
import net.tylermurphy.hideAndSeek.events.Taunt;
import net.tylermurphy.hideAndSeek.events.Worldborder;
import net.tylermurphy.hideAndSeek.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Start
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!Util.isSetup()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
            return;
        }
        if (!Main.plugin.status.equals("Standby")) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        if (!Main.plugin.board.isPlayer(sender)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_NOT_INGAME"));
            return;
        }
        if (Main.plugin.board.size() < Config.minPlayers) {
            sender.sendMessage(Config.errorPrefix + Localization.message("START_MIN_PLAYERS").addAmount(Config.minPlayers));
            return;
        }
        if (Bukkit.getServer().getWorld("hideandseek_" + Config.spawnWorld) != null) {
            Main.plugin.worldLoader.rollback();
        } else {
            Main.plugin.worldLoader.loadMap();
        }
        String seekerName = args.length < 1 ? ((Player)Main.plugin.board.getPlayers().stream().skip(new Random().nextInt(Main.plugin.board.size())).findFirst().get()).getName() : args[0];
        Player seeker = Main.plugin.board.getPlayer(seekerName);
        if (seeker == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("START_INVALID_NAME").addPlayer(seekerName));
            return;
        }
        Main.plugin.board.reload();
        for (Player temp : Main.plugin.board.getPlayers()) {
            if (temp.getName().equals(seeker.getName())) continue;
            Main.plugin.board.addHider(temp);
        }
        Main.plugin.board.addSeeker(seeker);
        Config.currentWorldborderSize = Config.worldborderSize;
        for (Player player : Main.plugin.board.getPlayers()) {
            player.getInventory().clear();
            player.setGameMode(GameMode.ADVENTURE);
            player.teleport(new Location(Bukkit.getWorld((String)("hideandseek_" + Config.spawnWorld)), Config.spawnPosition.getX(), Config.spawnPosition.getY(), Config.spawnPosition.getZ()));
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
        }
        for (Player player : Main.plugin.board.getSeekers()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 1000000, 127, false, false));
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 1000000, 127, false, false));
            player.sendTitle(ChatColor.RED + "" + ChatColor.BOLD + "SEEKER", ChatColor.WHITE + Localization.message("SEEKERS_SUBTITLE").toString(), 10, 70, 20);
        }
        for (Player player : Main.plugin.board.getHiders()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 1000000, 5, false, false));
            player.sendTitle(ChatColor.GOLD + "" + ChatColor.BOLD + "HIDER", ChatColor.WHITE + Localization.message("HIDERS_SUBTITLE").toString(), 10, 70, 20);
        }
        Worldborder.resetWorldborder("hideandseek_" + Config.spawnWorld);
        for (Player player : Main.plugin.board.getPlayers()) {
            Main.plugin.board.createGameBoard(player);
        }
        Main.plugin.board.reloadGameBoards();
        Main.plugin.status = "Starting";
        final int temp = Main.plugin.gameId;
        Util.broadcastMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(30));
        Util.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(20), Main.plugin.gameId, 200);
        Util.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(10), Main.plugin.gameId, 400);
        Util.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(5), Main.plugin.gameId, 500);
        Util.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(3), Main.plugin.gameId, 540);
        Util.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(2), Main.plugin.gameId, 560);
        Util.sendDelayedMessage(Config.messagePrefix + Localization.message("START_COUNTDOWN").addAmount(1), Main.plugin.gameId, 580);
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)Main.plugin, new Runnable(){

            @Override
            public void run() {
                if (temp != Main.plugin.gameId) {
                    return;
                }
                Util.broadcastMessage(Config.messagePrefix + Localization.message("START"));
                Main.plugin.status = "Playing";
                for (Player player : Main.plugin.board.getPlayers()) {
                    Util.resetPlayer(player);
                }
                Main.plugin.worldborder = null;
                Main.plugin.taunt = null;
                Main.plugin.glow = null;
                if (Config.worldborderEnabled) {
                    Main.plugin.worldborder = new Worldborder(Main.plugin.gameId);
                    Main.plugin.worldborder.schedule();
                }
                if (Config.tauntEnabled) {
                    Main.plugin.taunt = new Taunt(Main.plugin.gameId);
                    Main.plugin.taunt.schedule();
                }
                if (Config.glowEnabled) {
                    Main.plugin.glow = new Glow(Main.plugin.gameId);
                }
                if (Config.gameLength > 0) {
                    Main.plugin.timeLeft = Config.gameLength;
                }
            }
        }, 600L);
    }

    @Override
    public String getLabel() {
        return "start";
    }

    @Override
    public String getUsage() {
        return "<player>";
    }

    @Override
    public String getDescription() {
        return "Starts the game either with a random seeker or chosen one";
    }
}

