/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SetLobbyLocation
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!Main.plugin.status.equals("Standby")) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        Vector newLobbyPosition = new Vector();
        Player player = (Player)sender;
        if (player.getLocation().getBlockX() == 0 || player.getLocation().getBlockZ() == 0 || player.getLocation().getBlockY() == 0) {
            sender.sendMessage(Config.errorPrefix + Localization.message("NOT_AT_ZERO"));
            return;
        }
        newLobbyPosition.setX(player.getLocation().getBlockX());
        newLobbyPosition.setY(player.getLocation().getBlockY());
        newLobbyPosition.setZ(player.getLocation().getBlockZ());
        Config.lobbyWorld = player.getLocation().getWorld().getName();
        Config.lobbyPosition = newLobbyPosition;
        sender.sendMessage(Config.messagePrefix + Localization.message("LOBBY_SPAWN"));
        Config.addToConfig("spawns.lobby.x", Config.lobbyPosition.getX());
        Config.addToConfig("spawns.lobby.y", Config.lobbyPosition.getY());
        Config.addToConfig("spawns.lobby.z", Config.lobbyPosition.getZ());
        Config.addToConfig("spawns.lobby.world", player.getLocation().getWorld().getName());
        Config.saveConfig();
    }

    @Override
    public String getLabel() {
        return "setlobby";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Sets hide and seeks lobby location to current position";
    }
}

