/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SetExitLocation
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!Main.plugin.status.equals("Standby")) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        Vector newExitPosition = new Vector();
        Player player = (Player)sender;
        if (player.getLocation().getBlockX() == 0 || player.getLocation().getBlockZ() == 0 || player.getLocation().getBlockY() == 0) {
            sender.sendMessage(Config.errorPrefix + Localization.message("NOT_AT_ZERO"));
            return;
        }
        newExitPosition.setX(player.getLocation().getBlockX());
        newExitPosition.setY(player.getLocation().getBlockY());
        newExitPosition.setZ(player.getLocation().getBlockZ());
        Config.exitWorld = player.getLocation().getWorld().getName();
        Config.exitPosition = newExitPosition;
        sender.sendMessage(Config.messagePrefix + Localization.message("EXIT_SPAWN"));
        Config.addToConfig("spawns.exit.x", Config.exitPosition.getX());
        Config.addToConfig("spawns.exit.y", Config.exitPosition.getY());
        Config.addToConfig("spawns.exit.z", Config.exitPosition.getZ());
        Config.addToConfig("spawns.exit.world", player.getLocation().getWorld().getName());
        Config.saveConfig();
    }

    @Override
    public String getLabel() {
        return "setexit";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Sets hide and seeks exit location to current position and world";
    }
}

