/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Leave
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!Util.isSetup()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
            return;
        }
        Player player = Bukkit.getServer().getPlayer(sender.getName());
        if (player == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_ERROR"));
            return;
        }
        if (!Main.plugin.board.isPlayer(player)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_NOT_INGAME"));
            return;
        }
        if (Config.announceMessagesToNonPlayers) {
            Bukkit.broadcastMessage((String)(Config.messagePrefix + Localization.message("GAME_LEAVE").addPlayer((Entity)player)));
        } else {
            Util.broadcastMessage(Config.messagePrefix + Localization.message("GAME_LEAVE").addPlayer((Entity)player));
        }
        Main.plugin.board.removeBoard(player);
        Main.plugin.board.remove(player);
        player.teleport(new Location(Bukkit.getWorld((String)Config.exitWorld), Config.exitPosition.getX(), Config.exitPosition.getY(), Config.exitPosition.getZ()));
        if (Main.plugin.status.equals("Standby")) {
            Main.plugin.board.reloadLobbyBoards();
        } else {
            Main.plugin.board.reloadGameBoards();
            Main.plugin.board.reloadBoardTeams();
        }
    }

    @Override
    public String getLabel() {
        return "leave";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Leaves the lobby if game is set to manual join/leave";
    }
}

