/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Join
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!Util.isSetup()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
            return;
        }
        Player player = Bukkit.getServer().getPlayer(sender.getName());
        if (player == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_ERROR"));
            return;
        }
        if (Main.plugin.board.isPlayer(player)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INGAME"));
            return;
        }
        Join.join(player);
    }

    public static void join(Player player) {
        if (Main.plugin.status.equals("Standby")) {
            player.getInventory().clear();
            Main.plugin.board.addHider(player);
            if (Config.announceMessagesToNonPlayers) {
                Bukkit.broadcastMessage((String)(Config.messagePrefix + Localization.message("GAME_JOIN").addPlayer((Entity)player)));
            } else {
                Util.broadcastMessage(Config.messagePrefix + Localization.message("GAME_JOIN").addPlayer((Entity)player));
            }
            player.teleport(new Location(Bukkit.getWorld((String)Config.lobbyWorld), Config.lobbyPosition.getX(), Config.lobbyPosition.getY(), Config.lobbyPosition.getZ()));
            player.setGameMode(GameMode.ADVENTURE);
            Main.plugin.board.createLobbyBoard(player);
            Main.plugin.board.reloadLobbyBoards();
        } else {
            Main.plugin.board.addSpectator(player);
            player.sendMessage(Config.messagePrefix + Localization.message("GAME_JOIN_SPECTATOR"));
            player.setGameMode(GameMode.SPECTATOR);
            Main.plugin.board.createGameBoard(player);
            player.teleport(new Location(Bukkit.getWorld((String)("hideandseek_" + Config.spawnWorld)), Config.spawnPosition.getX(), Config.spawnPosition.getY(), Config.spawnPosition.getZ()));
        }
        player.setFoodLevel(20);
        player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue());
    }

    @Override
    public String getLabel() {
        return "join";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Joins the lobby if game is set to manual join/leave";
    }
}

