/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.bukkit;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.tylermurphy.hideAndSeek.command.About;
import net.tylermurphy.hideAndSeek.command.Help;
import net.tylermurphy.hideAndSeek.command.ICommand;
import net.tylermurphy.hideAndSeek.command.Join;
import net.tylermurphy.hideAndSeek.command.Leave;
import net.tylermurphy.hideAndSeek.command.Reload;
import net.tylermurphy.hideAndSeek.command.SaveMap;
import net.tylermurphy.hideAndSeek.command.SetBorder;
import net.tylermurphy.hideAndSeek.command.SetBounds;
import net.tylermurphy.hideAndSeek.command.SetExitLocation;
import net.tylermurphy.hideAndSeek.command.SetLobbyLocation;
import net.tylermurphy.hideAndSeek.command.SetSpawnLocation;
import net.tylermurphy.hideAndSeek.command.Setup;
import net.tylermurphy.hideAndSeek.command.Start;
import net.tylermurphy.hideAndSeek.command.Stop;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler {
    public static Map<String, ICommand> COMMAND_REGISTER = new LinkedHashMap<String, ICommand>();

    private static void registerCommand(ICommand command) {
        if (!COMMAND_REGISTER.containsKey(command.getLabel())) {
            COMMAND_REGISTER.put(command.getLabel().toLowerCase(), command);
        }
    }

    public static void registerCommands() {
        CommandHandler.registerCommand(new About());
        CommandHandler.registerCommand(new Help());
        CommandHandler.registerCommand(new Setup());
        CommandHandler.registerCommand(new Start());
        CommandHandler.registerCommand(new Stop());
        CommandHandler.registerCommand(new SetSpawnLocation());
        CommandHandler.registerCommand(new SetLobbyLocation());
        CommandHandler.registerCommand(new SetExitLocation());
        CommandHandler.registerCommand(new SetBorder());
        CommandHandler.registerCommand(new Reload());
        CommandHandler.registerCommand(new SaveMap());
        CommandHandler.registerCommand(new SetBounds());
        CommandHandler.registerCommand(new Join());
        CommandHandler.registerCommand(new Leave());
    }

    public static boolean handleCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_PLAYER_ONLY"));
        } else if (args.length < 1 || !COMMAND_REGISTER.containsKey(args[0].toLowerCase())) {
            if (Config.permissionsRequired && !sender.hasPermission("hideandseek.about")) {
                sender.sendMessage(Config.errorPrefix + Localization.LOCAL.get(""));
            } else {
                COMMAND_REGISTER.get("about").execute(sender, null);
            }
        } else if (!args[0].toLowerCase().equals("about") && !args[0].toLowerCase().equals("help") && SaveMap.runningBackup) {
            sender.sendMessage(Config.errorPrefix + Localization.message("MAPSAVE_INPROGRESS"));
        } else if (Config.permissionsRequired && !sender.hasPermission("hideandseek." + args[0].toLowerCase())) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_NOT_ALLOWED"));
        } else {
            try {
                COMMAND_REGISTER.get(args[0].toLowerCase()).execute(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            catch (Exception e) {
                sender.sendMessage(Config.errorPrefix + "An error has occured.");
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return CommandHandler.handleCommand(sender, command, label, args);
    }
}

