/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.util;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.Store;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class Functions {
    private static ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();

    public static void resetPlayer(Player player) {
        player.getInventory().clear();
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        if (Store.Seeker.getEntries().contains(player.getName())) {
            ItemStack diamondSword = new ItemStack(Material.DIAMOND_SWORD, 1);
            diamondSword.addEnchantment(Enchantment.DAMAGE_ALL, 1);
            ItemMeta diamondSwordMeta = diamondSword.getItemMeta();
            diamondSwordMeta.setDisplayName("Seeker Sword");
            diamondSwordMeta.setUnbreakable(true);
            diamondSword.setItemMeta(diamondSwordMeta);
            player.getInventory().addItem(new ItemStack[]{diamondSword});
            ItemStack wackyStick = new ItemStack(Material.STICK, 1);
            wackyStick.addUnsafeEnchantment(Enchantment.KNOCKBACK, 3);
            ItemMeta wackyStickMeta = wackyStick.getItemMeta();
            wackyStickMeta.setDisplayName("Wacky Stick");
            wackyStick.setItemMeta(wackyStickMeta);
            player.getInventory().addItem(new ItemStack[]{wackyStick});
        } else if (Store.Hider.getEntries().contains(player.getName())) {
            ItemStack stoneSword = new ItemStack(Material.STONE_SWORD, 1);
            stoneSword.addEnchantment(Enchantment.DAMAGE_ALL, 2);
            ItemMeta stoneSwordMeta = stoneSword.getItemMeta();
            stoneSwordMeta.setDisplayName("Hider Sword");
            stoneSwordMeta.setUnbreakable(true);
            stoneSword.setItemMeta(stoneSwordMeta);
            player.getInventory().addItem(new ItemStack[]{stoneSword});
            ItemStack splashPotion = new ItemStack(Material.SPLASH_POTION, 1);
            PotionMeta splashPotionMeta = (PotionMeta)splashPotion.getItemMeta();
            splashPotionMeta.setBasePotionData(new PotionData(PotionType.REGEN));
            splashPotion.setItemMeta((ItemMeta)splashPotionMeta);
            player.getInventory().addItem(new ItemStack[]{splashPotion});
            ItemStack potion = new ItemStack(Material.POTION, 2);
            PotionMeta potionMeta = (PotionMeta)potion.getItemMeta();
            potionMeta.setBasePotionData(new PotionData(PotionType.INSTANT_HEAL));
            potion.setItemMeta((ItemMeta)potionMeta);
            player.getInventory().addItem(new ItemStack[]{potion});
            ItemStack snowball = new ItemStack(Material.SNOWBALL, 1);
            ItemMeta snowballMeta = snowball.getItemMeta();
            snowballMeta.setDisplayName("Glow Powerup");
            ArrayList<String> snowballLore = new ArrayList<String>();
            snowballLore.add("Throw to make all seekers glow");
            snowballLore.add("Last 30s, all hiders can see it");
            snowballLore.add("Time stacks on multi use");
            snowballMeta.setLore(snowballLore);
            player.getInventory().addItem(new ItemStack[]{snowball});
        }
    }

    public static void emptyOfflinePlayers() {
        for (String entry : Store.Hider.getEntries()) {
            if (Store.playerList.containsKey(entry)) continue;
            Store.Hider.removeEntry(entry);
        }
        for (String entry : Store.Seeker.getEntries()) {
            if (Store.playerList.containsKey(entry)) continue;
            Store.Seeker.removeEntry(entry);
        }
        for (String entry : Store.Spectator.getEntries()) {
            if (Store.playerList.containsKey(entry)) continue;
            Store.Spectator.removeEntry(entry);
        }
    }

    public static void loadScoreboard() {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        Scoreboard mainBoard = manager.getMainScoreboard();
        try {
            mainBoard.registerNewTeam("Seeker");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Store.Seeker = mainBoard.getTeam("Seeker");
        Store.Seeker.setColor(ChatColor.RED);
        Store.Seeker.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        Store.Seeker.setAllowFriendlyFire(false);
        try {
            mainBoard.registerNewTeam("Hider");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Store.Hider = mainBoard.getTeam("Hider");
        Store.Hider.setColor(ChatColor.GOLD);
        Store.Hider.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        Store.Hider.setAllowFriendlyFire(false);
        try {
            mainBoard.registerNewTeam("Spectator");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Store.Spectator = mainBoard.getTeam("Spectator");
        Store.Spectator.setColor(ChatColor.GRAY);
        Store.Spectator.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        Store.Spectator.setAllowFriendlyFire(false);
        Store.board = mainBoard;
    }

    public static void playSound(Player player, Sound sound, float volume, float pitch) {
        PacketContainer packet = protocolManager.createPacket(PacketType.Play.Server.NAMED_SOUND_EFFECT);
        packet.getSoundCategories().write(0, (Object)EnumWrappers.SoundCategory.MASTER);
        packet.getSoundEffects().write(0, (Object)sound);
        packet.getIntegers().write(0, (Object)((int)(player.getLocation().getX() * 8.0)));
        packet.getIntegers().write(1, (Object)((int)(player.getLocation().getY() * 8.0)));
        packet.getIntegers().write(2, (Object)((int)(player.getLocation().getZ() * 8.0)));
        packet.getFloat().write(0, (Object)Float.valueOf(volume));
        packet.getFloat().write(1, (Object)Float.valueOf(pitch));
        try {
            protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void setGlow(Player player, Player target, boolean glowing) {
        PacketContainer packet = protocolManager.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet.getIntegers().write(0, (Object)target.getEntityId());
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.get(Byte.class);
        watcher.setEntity((Entity)target);
        if (glowing) {
            watcher.setObject(0, serializer, (Object)64);
        } else {
            watcher.setObject(0, serializer, (Object)0);
        }
        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        try {
            protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void scheduleTaunt() {
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)Main.plugin, new Runnable(){

            @Override
            public void run() {
                int temp = Store.gameId;
                while (true) {
                    if (Store.tauntPlayer != null && !Store.tauntPlayer.equals("")) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (Store.gameId == temp) continue;
                        break;
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Store.gameId != temp) break;
                    if (!(Math.random() > 0.8)) continue;
                    Player taunted = null;
                    int rand = (int)(Math.random() * (double)Store.Hider.getEntries().size());
                    for (Player player : Store.playerList.values()) {
                        if (!Store.Hider.hasEntry(player.getName()) || --rand != 0) continue;
                        taunted = player;
                        break;
                    }
                    if (taunted == null) continue;
                    taunted.sendMessage(ChatColor.RED + "" + ChatColor.ITALIC + "Oh no! You have been chosed to be taunted.");
                    Bukkit.getServer().broadcastMessage(ChatColor.YELLOW + "Taunt >" + ChatColor.WHITE + " A random hider will be taunted in the next 30s");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Store.gameId != temp) break;
                    Store.tauntPlayer = taunted.getName();
                }
            }
        });
    }

    public static void scheduleWorldborder() {
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)Main.plugin, new Runnable(){

            @Override
            public void run() {
                int temp = Store.gameId;
                while (true) {
                    try {
                        Thread.sleep(60000 * Store.worldborderDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Store.gameId != temp || Store.currentWorldborderSize - 100 <= 100) break;
                    Bukkit.getServer().broadcastMessage(ChatColor.RED + "World Border> " + ChatColor.WHITE + "Worldborder decreacing by 100 blocks over the next 30s");
                    Store.currentWorldborderSize -= 100;
                    Store.decreaseBorder = true;
                }
            }
        });
    }

    public static void resetWorldborder() {
        if (Store.worldborderEnabled) {
            World world = Bukkit.getWorld((String)"world");
            WorldBorder border = world.getWorldBorder();
            border.setSize((double)Store.worldborderSize);
            border.setCenter(Store.worldborderPosition.getX(), Store.worldborderPosition.getZ());
            Store.currentWorldborderSize = Store.worldborderSize;
        } else {
            World world = Bukkit.getWorld((String)"world");
            WorldBorder border = world.getWorldBorder();
            border.setSize(3.0E7);
            border.setCenter(0.0, 0.0);
        }
    }
}

