/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.commands;

import net.tylermurphy.hideAndSeek.Store;
import net.tylermurphy.hideAndSeek.util.Functions;
import net.tylermurphy.hideAndSeek.util.ICommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SetBorder
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        int delay;
        int num;
        if (!Store.status.equals("Standby") && !Store.status.equals("Setup")) {
            sender.sendMessage(Store.errorPrefix + "Game is currently in session");
            return;
        }
        if (Store.spawnPosition == null) {
            sender.sendMessage(Store.errorPrefix + "Please set spawn position first");
            return;
        }
        if (args.length < 2) {
            Store.getConfig().set("borderEnabled", (Object)false);
            Store.worldborderEnabled = false;
            Store.saveConfig();
            sender.sendMessage(Store.messagePrefix + "Disabled worldborder.");
            Functions.resetWorldborder();
            return;
        }
        try {
            num = Integer.parseInt(args[0]);
        }
        catch (Exception e) {
            sender.sendMessage(Store.errorPrefix + "Invalid integer: " + args[0]);
            return;
        }
        try {
            delay = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            sender.sendMessage(Store.errorPrefix + "Invalid integer: " + args[1]);
            return;
        }
        if (num < 100) {
            sender.sendMessage(Store.errorPrefix + "Worldborder cannot be smaller than 100 blocks.");
            return;
        }
        Vector newWorldborderPosition = new Vector();
        Player player = (Player)sender;
        newWorldborderPosition.setX(player.getLocation().getBlockX());
        newWorldborderPosition.setY(0);
        newWorldborderPosition.setZ(player.getLocation().getBlockZ());
        if (Store.spawnPosition.distance(newWorldborderPosition) > 100.0) {
            sender.sendMessage(Store.errorPrefix + "Spawn position must be 100 from worldborder center");
            return;
        }
        Store.worldborderPosition = newWorldborderPosition;
        Store.worldborderSize = num;
        Store.worldborderDelay = delay;
        sender.sendMessage(Store.messagePrefix + "Set border center to current location, size to " + num + ", and delay to " + delay);
        Store.getConfig().set("borderPosition", (Object)newWorldborderPosition);
        Store.getConfig().set("borderSize", (Object)num);
        Store.getConfig().set("borderDelay", (Object)delay);
        Store.getConfig().set("borderEnabled", (Object)false);
        Store.worldborderEnabled = true;
        Store.saveConfig();
        Functions.resetWorldborder();
    }

    @Override
    public String getLabel() {
        return "setBorder";
    }

    @Override
    public String getUsage() {
        return "<size> <delay>";
    }

    @Override
    public String getDescription() {
        return "Sets worldboarder's center location, size in blocks, and delay in minutes per shrink. Add no arguments to disable.";
    }
}

