/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.manager;

import net.md_5.bungee.api.ChatColor;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.Store;
import net.tylermurphy.hideAndSeek.util.Functions;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class EventManager
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (Store.status.equals("Playing") || Store.status.equals("Starting")) {
            Store.Spectator.addEntry(event.getPlayer().getName());
            event.getPlayer().sendMessage(Store.messagePrefix + "You have joined mid game, and thus have been placed on the spectator team.");
            event.getPlayer().setGameMode(GameMode.SPECTATOR);
            event.getPlayer().getInventory().clear();
            for (PotionEffect effect : event.getPlayer().getActivePotionEffects()) {
                event.getPlayer().removePotionEffect(effect.getType());
            }
            event.getPlayer().teleport(new Location(event.getPlayer().getWorld(), Store.spawnPosition.getX(), Store.spawnPosition.getY(), Store.spawnPosition.getZ()));
        } else if (Store.status.equals("Setup") || Store.status.equals("Standby")) {
            Store.Hider.addEntry(event.getPlayer().getName());
        }
        Store.playerList.put(event.getPlayer().getName(), event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Store.playerList.remove(event.getPlayer().getName());
        Store.Hider.removeEntry(event.getPlayer().getName());
        Store.Seeker.removeEntry(event.getPlayer().getName());
        Store.Spectator.removeEntry(event.getPlayer().getName());
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            if (!Store.status.equals("Playing")) {
                event.setCancelled(true);
                return;
            }
            Player player = (Player)event.getEntity();
            if (player.getHealth() - event.getDamage() < 0.0) {
                if (Store.spawnPosition == null) {
                    return;
                }
                event.setCancelled(true);
                player.setHealth(player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
                player.teleport(new Location(player.getWorld(), Store.spawnPosition.getX(), Store.spawnPosition.getY(), Store.spawnPosition.getZ()));
                Functions.playSound(player, Sound.ENTITY_PLAYER_DEATH, 1.0f, 1.0f);
                if (Store.Hider.hasEntry(event.getEntity().getName())) {
                    Bukkit.broadcastMessage((String)String.format(Store.messagePrefix + "%s%s%s has died and become a seeker", ChatColor.GOLD, event.getEntity().getName(), ChatColor.WHITE));
                }
                if (Store.Seeker.hasEntry(event.getEntity().getName())) {
                    Bukkit.broadcastMessage((String)String.format(Store.messagePrefix + "%s%s%s has been beat by a hider", ChatColor.RED, event.getEntity().getName(), ChatColor.WHITE));
                }
                Store.Seeker.addEntry(player.getName());
                Functions.resetPlayer(player);
            }
        }
    }

    @EventHandler
    public void onProjectile(ProjectileLaunchEvent event) {
        Player player;
        Snowball snowball;
        if (!Store.status.equals("Playing")) {
            return;
        }
        if (event.getEntity() instanceof Snowball && (snowball = (Snowball)event.getEntity()).getShooter() instanceof Player && Store.Hider.hasEntry((player = (Player)snowball.getShooter()).getName())) {
            ++Store.glowTime;
            snowball.remove();
            player.getInventory().remove(Material.SNOWBALL);
            final int temp = Store.gameId;
            Bukkit.getServer().getScheduler().runTaskLater((Plugin)Main.plugin, new Runnable(){

                @Override
                public void run() {
                    if (temp != Store.gameId) {
                        return;
                    }
                    --Store.glowTime;
                }
            }, 600L);
        }
    }

    @EventHandler
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerRegainHealth(EntityRegainHealthEvent event) {
        if (event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED || event.getRegainReason() == EntityRegainHealthEvent.RegainReason.REGEN) {
            event.setCancelled(true);
        }
    }
}

