/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.manager;

import net.tylermurphy.hideAndSeek.Store;
import net.tylermurphy.hideAndSeek.commands.Stop;
import net.tylermurphy.hideAndSeek.util.Functions;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TickManager {
    static int tick = 0;

    public static void onTick() {
        if (Store.board == null) {
            Functions.loadScoreboard();
        }
        Functions.emptyOfflinePlayers();
        for (Player player : Store.playerList.values()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 1000000, 127, false, false));
        }
        if (Store.status.equals("Standby") || Store.status.equals("Setup")) {
            TickManager.onStandby();
        } else if (Store.status.equals("Starting")) {
            TickManager.onStarting();
        } else if (Store.status.equals("Playing")) {
            TickManager.onPlaying();
        }
        ++tick;
        if ((Store.status.equals("Starting") || Store.status.equals("Playing")) && Store.Hider.getSize() < 1) {
            Bukkit.broadcastMessage((String)(Store.messagePrefix + "Game over! All hiders have been found."));
            Stop.onStop();
        }
        if ((Store.status.equals("Starting") || Store.status.equals("Playing")) && Store.Seeker.getSize() < 1) {
            Bukkit.broadcastMessage((String)(Store.messagePrefix + "Game has ended as all seekers have quit."));
            Stop.onStop();
        }
    }

    private static void onStandby() {
        for (Player player : Store.playerList.values()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 1000000, 127, false, false));
        }
    }

    private static void onStarting() {
        for (String playerName : Store.Seeker.getEntries()) {
            Player player = Store.playerList.get(playerName);
            if (player == null) continue;
            player.teleport(new Location(player.getWorld(), Store.spawnPosition.getX(), Store.spawnPosition.getY(), Store.spawnPosition.getZ()));
        }
    }

    private static void onPlaying() {
        Player player;
        if (Store.decreaseBorder) {
            World world = Bukkit.getWorld((String)"world");
            WorldBorder border = world.getWorldBorder();
            border.setSize(border.getSize() - 100.0, 30L);
            Store.decreaseBorder = false;
        }
        if (!Store.tauntPlayer.equals("")) {
            Player taunted = Store.playerList.get(Store.tauntPlayer);
            if (taunted != null) {
                Firework fw = (Firework)taunted.getLocation().getWorld().spawnEntity(taunted.getLocation(), EntityType.FIREWORK);
                FireworkMeta fwm = fw.getFireworkMeta();
                fwm.setPower(4);
                fwm.addEffect(FireworkEffect.builder().withColor(Color.BLUE).withColor(Color.RED).withColor(Color.YELLOW).with(FireworkEffect.Type.STAR).with(FireworkEffect.Type.BALL).with(FireworkEffect.Type.BALL_LARGE).flicker(true).withTrail().build());
                fw.setFireworkMeta(fwm);
                Bukkit.getServer().broadcastMessage(ChatColor.YELLOW + "Taunt >" + ChatColor.WHITE + " Taunt has been activated");
            }
            Store.tauntPlayer = "";
        }
        for (Player player2 : Store.playerList.values()) {
            player2.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, 1000000, 1, false, false));
        }
        for (String playerName : Store.Seeker.getEntries()) {
            player = Store.playerList.get(playerName);
            if (player != null) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 1000000, 2, false, false));
                player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 1000000, 1, false, false));
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 1000000, 1, false, false));
                player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, 1000000, 10, false, false));
            }
            if (Store.glowTime > 0) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 1000000, 1, false, false));
                continue;
            }
            player.removePotionEffect(PotionEffectType.GLOWING);
        }
        for (String playerName : Store.Hider.getEntries()) {
            player = Store.playerList.get(playerName);
            if (player != null) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, 1000000, 1, false, false));
            }
            int distance = 100;
            for (String seekerName : Store.Seeker.getEntries()) {
                Player seeker = Store.playerList.get(seekerName);
                int temp = (int)player.getLocation().distance(seeker.getLocation());
                if (distance <= temp) continue;
                distance = temp;
            }
            switch (tick % 10) {
                case 0: {
                    if (distance < 30) {
                        Functions.playSound(player, Sound.BLOCK_NOTE_BLOCK_BASEDRUM, 0.5f, 1.0f);
                    }
                    if (distance >= 10) break;
                    Functions.playSound(player, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                    break;
                }
                case 3: {
                    if (distance < 30) {
                        Functions.playSound(player, Sound.BLOCK_NOTE_BLOCK_BASEDRUM, 0.3f, 1.0f);
                    }
                    if (distance >= 10) break;
                    Functions.playSound(player, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                    break;
                }
                case 6: {
                    if (distance >= 10) break;
                    Functions.playSound(player, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                    break;
                }
                case 9: {
                    if (distance >= 20) break;
                    Functions.playSound(player, Sound.BLOCK_NOTE_BLOCK_BIT, 0.3f, 1.0f);
                }
            }
        }
    }
}

