/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.commands;

import net.tylermurphy.hideAndSeek.ICommand;
import net.tylermurphy.hideAndSeek.Store;
import net.tylermurphy.hideAndSeek.manager.WorldborderManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Stop
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!Store.status.equals("Starting") && !Store.status.equals("Playing")) {
            sender.sendMessage(Store.errorPrefix + "There is no game in progress");
            return;
        }
        Bukkit.broadcastMessage((String)(Store.messagePrefix + "Game has been force stopped."));
        Stop.onStop();
    }

    @Override
    public String getLabel() {
        return "stop";
    }

    public static void onStop() {
        if (Store.status.equals("Standby") || Store.status.equals("Setup")) {
            return;
        }
        Store.status = "Standby";
        ++Store.gameId;
        for (Player player : Store.playerList.values()) {
            player.setGameMode(GameMode.ADVENTURE);
            Store.Hider.addEntry(player.getName());
            player.getInventory().clear();
            player.teleport(new Location(player.getWorld(), Store.spawnPosition.getX(), Store.spawnPosition.getY(), Store.spawnPosition.getZ()));
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 1, 100));
        }
        WorldborderManager.reset();
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Stops the game";
    }
}

