/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.commands;

import net.tylermurphy.hideAndSeek.ICommand;
import net.tylermurphy.hideAndSeek.Store;
import net.tylermurphy.hideAndSeek.manager.WorldborderManager;
import org.bukkit.command.CommandSender;

public class EnableBorder
implements ICommand {
    @Override
    public void execute(CommandSender sender, String[] args) {
        boolean bool;
        if (!Store.status.equals("Standby") && !Store.status.equals("Setup")) {
            sender.sendMessage(Store.errorPrefix + "Game is currently in session");
            return;
        }
        if (Store.worldborderPosition == null) {
            sender.sendMessage(Store.errorPrefix + "Please setup worldborder info before enabling");
            return;
        }
        try {
            bool = Boolean.parseBoolean(args[0]);
        }
        catch (Exception e) {
            sender.sendMessage(Store.errorPrefix + "Please enter true or false");
            return;
        }
        if (Store.spawnPosition != null && Store.worldborderPosition != null && Store.spawnPosition.distance(Store.worldborderPosition) > 100.0) {
            sender.sendMessage(Store.errorPrefix + "Cannot enable worldborder, spawn position is outside 100 blocks from worldborder");
            return;
        }
        sender.sendMessage(Store.messagePrefix + "Set worldborder to " + args[0]);
        Store.getConfig().set("borderEnabled", (Object)bool);
        Store.worldborderEnabled = bool;
        Store.saveConfig();
        WorldborderManager.reset();
    }

    @Override
    public String getLabel() {
        return "enableBorder";
    }

    @Override
    public String getUsage() {
        return "<true/false>";
    }

    @Override
    public String getDescription() {
        return "Enables or disables worldborder";
    }
}

