/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.manager;

import net.tylermurphy.hideAndSeek.Store;
import net.tylermurphy.hideAndSeek.commands.Stop;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.Team;

public class TickManager {
    static int tick = 0;

    public static void onTick() {
        if (Store.board == null) {
            return;
        }
        TickManager.checkTeams();
        for (Player player : Store.playerList.values()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 1000000, 127, false, false));
        }
        if (Store.status.equals("Standby") || Store.status.equals("Setup")) {
            TickManager.onStandby();
        } else if (Store.status.equals("Starting")) {
            TickManager.onStarting();
        } else if (Store.status.equals("Playing")) {
            TickManager.onPlaying();
        }
        ++tick;
        tick %= 10;
        if (Store.Hider.getSize() < 1) {
            Stop.onStop(false);
        }
        if (Store.Seeker.getSize() < 1) {
            Stop.onStop(false);
        }
    }

    private static void checkTeams() {
        try {
            Store.Hider.getSize();
        }
        catch (Exception e) {
            Store.board.registerNewTeam("Hider");
            Store.Hider = Store.board.getTeam("Hider");
            Store.Hider.setColor(ChatColor.GOLD);
            Store.Hider.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            Store.Hider.setAllowFriendlyFire(false);
        }
        try {
            Store.Seeker.getSize();
        }
        catch (Exception e) {
            Store.board.registerNewTeam("Seeker");
            Store.Seeker = Store.board.getTeam("Seeker");
            Store.Seeker.setColor(ChatColor.RED);
            Store.Seeker.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            Store.Seeker.setAllowFriendlyFire(false);
        }
        try {
            Store.Spectator.getSize();
        }
        catch (Exception e) {
            Store.board.registerNewTeam("Spectator");
            Store.Spectator = Store.board.getTeam("Spectator");
            Store.Spectator.setColor(ChatColor.GRAY);
            Store.Spectator.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            Store.Spectator.setAllowFriendlyFire(false);
        }
        for (String entry : Store.Hider.getEntries()) {
            if (Store.playerList.containsKey(entry)) continue;
            Store.Hider.removeEntry(entry);
        }
        for (String entry : Store.Seeker.getEntries()) {
            if (Store.playerList.containsKey(entry)) continue;
            Store.Seeker.removeEntry(entry);
        }
        for (String entry : Store.Spectator.getEntries()) {
            if (Store.playerList.containsKey(entry)) continue;
            Store.Spectator.removeEntry(entry);
        }
    }

    private static void onStandby() {
        for (Player player : Store.playerList.values()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 1000000, 127, false, false));
        }
    }

    private static void onStarting() {
        for (String playerName : Store.Seeker.getEntries()) {
            Player player = Store.playerList.get(playerName);
            if (player == null) continue;
            player.teleport(new Location(player.getWorld(), Store.spawnPosition.getX(), Store.spawnPosition.getY(), Store.spawnPosition.getZ()));
        }
    }

    private static void onPlaying() {
        Player player;
        if (Store.decreaseBorder) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), "worldborder add -100 30");
            Store.decreaseBorder = false;
        }
        if (!Store.tauntPlayer.equals("")) {
            Player taunted = Store.playerList.get(Store.tauntPlayer);
            if (taunted != null) {
                Firework fw = (Firework)taunted.getLocation().getWorld().spawnEntity(taunted.getLocation(), EntityType.FIREWORK);
                FireworkMeta fwm = fw.getFireworkMeta();
                fwm.setPower(2);
                fwm.addEffect(FireworkEffect.builder().withColor(Color.BLUE).withColor(Color.RED).withColor(Color.YELLOW).with(FireworkEffect.Type.STAR).with(FireworkEffect.Type.BALL).with(FireworkEffect.Type.BALL_LARGE).flicker(true).withTrail().build());
                fw.setFireworkMeta(fwm);
                Bukkit.getServer().broadcastMessage(ChatColor.YELLOW + "Taunt >" + ChatColor.WHITE + " Taunt has been activated");
            }
            Store.tauntPlayer = "";
        }
        for (Player player2 : Store.playerList.values()) {
            player2.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, 1000000, 1, false, false));
            if (Store.getPlayerData(player2.getName(), "Death") > 0) {
                Store.setPlayerData(player2.getName(), "Death", 0);
                Store.Seeker.addEntry(player2.getName());
            }
            if (Store.getPlayerData(player2.getName(), "GiveStatus") <= 0) continue;
            Store.setPlayerData(player2.getName(), "GiveStatus", 0);
            player2.getInventory().clear();
            for (PotionEffect effect : player2.getActivePotionEffects()) {
                player2.removePotionEffect(effect.getType());
            }
            if (Store.Seeker.getEntries().contains(player2.getName())) {
                ItemStack diamondSword = new ItemStack(Material.DIAMOND_SWORD, 1);
                diamondSword.addEnchantment(Enchantment.DAMAGE_ALL, 1);
                ItemMeta diamondSwordMeta = diamondSword.getItemMeta();
                diamondSwordMeta.setDisplayName("Seeker Sword");
                diamondSwordMeta.setUnbreakable(true);
                diamondSword.setItemMeta(diamondSwordMeta);
                player2.getInventory().addItem(new ItemStack[]{diamondSword});
                ItemStack wackyStick = new ItemStack(Material.STICK, 1);
                wackyStick.addUnsafeEnchantment(Enchantment.KNOCKBACK, 3);
                ItemMeta wackyStickMeta = wackyStick.getItemMeta();
                wackyStickMeta.setDisplayName("Wacky Stick");
                wackyStick.setItemMeta(wackyStickMeta);
                player2.getInventory().addItem(new ItemStack[]{wackyStick});
                continue;
            }
            if (!Store.Hider.getEntries().contains(player2.getName())) continue;
            ItemStack stoneSword = new ItemStack(Material.STONE_SWORD, 1);
            stoneSword.addEnchantment(Enchantment.DAMAGE_ALL, 2);
            ItemMeta stoneSwordMeta = stoneSword.getItemMeta();
            stoneSwordMeta.setDisplayName("Hider Sword");
            stoneSwordMeta.setUnbreakable(true);
            stoneSword.setItemMeta(stoneSwordMeta);
            player2.getInventory().addItem(new ItemStack[]{stoneSword});
            ItemStack splashPotion = new ItemStack(Material.SPLASH_POTION, 1);
            PotionMeta splashPotionMeta = (PotionMeta)splashPotion.getItemMeta();
            splashPotionMeta.setBasePotionData(new PotionData(PotionType.REGEN));
            splashPotion.setItemMeta((ItemMeta)splashPotionMeta);
            player2.getInventory().addItem(new ItemStack[]{splashPotion});
            ItemStack potion = new ItemStack(Material.POTION, 2);
            PotionMeta potionMeta = (PotionMeta)potion.getItemMeta();
            potionMeta.setBasePotionData(new PotionData(PotionType.INSTANT_HEAL));
            potion.setItemMeta((ItemMeta)potionMeta);
            player2.getInventory().addItem(new ItemStack[]{potion});
        }
        for (String playerName : Store.Seeker.getEntries()) {
            player = Store.playerList.get(playerName);
            if (player == null) continue;
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 1000000, 2, false, false));
            player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 1000000, 1, false, false));
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 1000000, 1, false, false));
            player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, 1000000, 10, false, false));
        }
        for (String playerName : Store.Hider.getEntries()) {
            player = Store.playerList.get(playerName);
            if (player != null) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, 1000000, 1, false, false));
            }
            int distance = 100;
            for (String seekerName : Store.Seeker.getEntries()) {
                Player seeker = Store.playerList.get(seekerName);
                int temp = (int)player.getLocation().distance(seeker.getLocation());
                if (distance <= temp) continue;
                distance = temp;
            }
            int x = player.getLocation().getBlockX();
            int y = player.getLocation().getBlockY();
            int z = player.getLocation().getBlockZ();
            switch (tick) {
                case 0: {
                    if (distance < 30) {
                        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), String.format("playsound minecraft:block.note_block.basedrum master %s %s %s %s .5 1", player.getName(), x, y, z));
                    }
                    if (distance >= 10) break;
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), String.format("playsound minecraft:block.note_block.bit master %s %s %s %s .3 1", player.getName(), x, y, z));
                    break;
                }
                case 3: {
                    if (distance < 30) {
                        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), String.format("playsound minecraft:block.note_block.basedrum master %s %s %s %s 3.31", player.getName(), x, y, z));
                    }
                    if (distance >= 10) break;
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), String.format("playsound minecraft:block.note_block.bit master %s %s %s %s .3 1", player.getName(), x, y, z));
                    break;
                }
                case 6: {
                    if (distance >= 10) break;
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), String.format("playsound minecraft:block.note_block.bit master %s %s %s %s .3 1", player.getName(), x, y, z));
                    break;
                }
                case 9: {
                    if (distance >= 20) break;
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), String.format("playsound minecraft:block.note_block.bit master %s %s %s %s .3 1", player.getName(), x, y, z));
                }
            }
        }
    }
}

