/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.manager;

import net.md_5.bungee.api.ChatColor;
import net.tylermurphy.hideAndSeek.Store;
import net.tylermurphy.hideAndSeek.manager.BoardManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;

public class EventManager
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (Store.status.equals("Playing") || Store.status.equals("Starting")) {
            Store.Spectator.addEntry(event.getPlayer().getName());
            Store.resetPlayerData(event.getPlayer().getName(), false);
            event.getPlayer().sendMessage(Store.messagePrefix + "You have joined mid game, and thus have been placed on the spectator team.");
            event.getPlayer().setGameMode(GameMode.SPECTATOR);
            event.getPlayer().getInventory().clear();
            for (PotionEffect effect : event.getPlayer().getActivePotionEffects()) {
                event.getPlayer().removePotionEffect(effect.getType());
            }
            event.getPlayer().teleport(new Location(event.getPlayer().getWorld(), Store.spawnPosition.getX(), Store.spawnPosition.getY(), Store.spawnPosition.getZ()));
        } else if (Store.status.equals("Setup") || Store.status.equals("Standby")) {
            Store.Hider.addEntry(event.getPlayer().getName());
        }
        Store.playerList.put(event.getPlayer().getName(), event.getPlayer());
        if (Store.board == null) {
            BoardManager.loadScoreboard();
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Store.playerList.remove(event.getPlayer().getName());
        Store.Hider.removeEntry(event.getPlayer().getName());
        Store.Seeker.removeEntry(event.getPlayer().getName());
        Store.Spectator.removeEntry(event.getPlayer().getName());
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        if (Store.status.equals("Playing")) {
            if (Store.Hider.hasEntry(event.getEntity().getName())) {
                Bukkit.getServer().broadcastMessage(String.format(Store.messagePrefix + "%s%s%s has died and become a seeker", ChatColor.GOLD, event.getEntity().getName(), ChatColor.WHITE));
            }
            if (Store.Seeker.hasEntry(event.getEntity().getName())) {
                Bukkit.getServer().broadcastMessage(String.format(Store.messagePrefix + "%s%s%s has been beat by a hider", ChatColor.RED, event.getEntity().getName(), ChatColor.WHITE));
            }
            Store.setPlayerData(event.getEntity().getName(), "Death", 1);
            Store.setPlayerData(event.getEntity().getName(), "GiveStatus", 1);
        }
    }
}

