# zsh shell initalization file

# export 'SHELL' and 'TERM' to child processes
export SHELL
export TERM

# check for non-interactive shell.
if [[ $- != *i* ]]; then
    # We are being invoked from a non-interactive shell.  If this
    # is an SSH session (as in "ssh host command"), source
    # /etc/profile so we get PATH and other essential variables.
    [[ -n "$SSH_CLIENT" ]] && source /etc/profile

    # Don't do anything else.
    return
fi

# load zsh plugins
setopt extendedglob
bindkey -e
autoload -U compinit
compinit
autoload -U colors && colors
setopt promptsubst

# prompt
function prompt_char {
    if [ $UID -eq 0 ]; then echo "#"; else echo "$"; fi
}
PROMPT='%(!.%F{9}.%F{10})%n@%m: %F{15}%c%F{12}$(prompt_char)%F{7} '
PROMPT2='%_%F{12}:%F{15} '

# aliases
alias ls='ls --color=auto'
alias rf="rm -fr" # remove le french hon hon hon
alias vim="nvim"

# manpages
export LESS_TERMCAP_md=$'\e[1;36m'
export LESS_TERMCAP_me=$'\e[0m'
export LESS_TERMCAP_se=$'\e[0m'
export LESS_TERMCAP_so=$'\e[1;92m'
export LESS_TERMCAP_ue=$'\e[0m'
export LESS_TERMCAP_us=$'\e[1;35m'
export GROFF_NO_SGR=1

# keybinds
bindkey "\e[1;5D" backward-word
bindkey "\e[1;5C" forward-word
bindkey "\e[3;5~" kill-word
bindkey "\C-_"    backward-kill-word
bindkey "\e[3~" delete-char
bindkey "\e[H"  beginning-of-line
bindkey "\e[F"  end-of-li
